;ELF LINKER FOR TASM/MASM
;(c) Vecna 2004
;
;This sample tool is a SOCKS4 proxy for Linux. It listen in port 1080, and 
;allow multiple connections.
;
;Coded in TASM Syntax

.386
.model flat
locals

MAX_CONN equ 5
STDOUT   equ 0

include ../../inc/syscall2.inc
include ../../inc/socks4.inc

.data
copyright db "SOCKS4 (c) Vecna 2002",10
copyright_size equ $-copyright

exitmsg db "Exiting...",10
exitmsg_size equ $-exitmsg

socket_ok db ":socket() created",10
socket_ok_size equ $-socket_ok

bind_ok db ":bind()ed",10
bind_ok_size equ $-bind_ok

listen_ok db ":listen()ing",10
listen_ok_size equ $-listen_ok

accept_ok db ":accept() got a connection...",10
accept_ok_size equ $-accept_ok

forking db "+its a socks4 proxy connection! fork()ing...",10
forking_size equ $-forking

connected db ":connect()ed to foreign host! relaying...",10
connected_size equ $-connected

hacker2server db "*hacker->server",10
hacker2server_size equ $-hacker2server

server2hacker db "*server->hacker",10
server2hacker_size equ $-server2hacker

waiting db 10,":waiting for connections...",10
waiting_size equ $-waiting

running db 10,":fork()",10
running_size equ $-running



.code

start	proc
       push copyright_size
       mov ecx, offset copyright
       pop edx
       call dbg_output

       push 6
       push 1
       push 2

       push __NR_socketcall
       pop eax
       push SYS_SOCKET
       pop ebx
       mov ecx,esp
       int 80h
       add esp,3*4
       mov ebp,eax
       inc eax
       jz @@jz2exit

       push socket_ok_size
       mov ecx, offset socket_ok
       pop edx
       call dbg_output

       push 0
       push 0
       push 0
       push 038040002h
       mov eax,esp

       push 16
       push eax
       push ebp

       push __NR_socketcall
       pop eax
       push SYS_BIND
       pop ebx
       mov ecx,esp
       int 80h
       add esp, 7*4
       test eax,eax
       jnz @@jnz2exit

       push bind_ok_size
       mov ecx,offset bind_ok
       pop edx
       call dbg_output

       push MAX_CONN
       push ebp

       push __NR_socketcall
       pop eax
       push SYS_LISTEN
       pop ebx
       mov ecx,esp
       int 80h
       add esp, 2*2
       test eax,eax
  @@jnz2exit:
       jnz @@exit

       push listen_ok_size
       mov ecx, offset listen_ok
       pop edx
       call dbg_output

  @@wait_connection:
       push waiting_size
       mov ecx, offset waiting
       pop edx
       call dbg_output

       push 0
       push 0
       push ebp

       push __NR_socketcall
       pop eax
       push SYS_ACCEPT
       pop ebx
       mov ecx,esp
       int 80h
       add esp, 3*4
       mov edi, eax
       inc eax
  @@jz2exit:
       jz @@exit

       push accept_ok_size
       mov ecx, offset accept_ok
       pop edx
       call dbg_output

       sub esp, _s4rq_size
       mov eax,esp

       push 0
       push _s4rq_size
       push eax
       push edi

       push __NR_socketcall
       pop eax
       push SYS_RECV
       pop ebx
       mov ecx,esp
       int 80h
       inc eax
       jz @@close_continue2

       cmp byte ptr [esp+s4rq_vn+4*4],SOCKS4_VERSION
       jne @@close_continue2

       cmp byte ptr [esp+s4rq_cd+4*4],SOCKS4_CONNECT
       jne @@close_continue2

       push forking_size
       mov ecx, offset forking
       pop edx
       call dbg_output

  @@connect:
       push __NR_fork
       pop eax
       int 80h
       test eax,eax
       jz cmd_connect
       jmp @@continue

  @@close_continue2:
       mov ebx,edi
       push __NR_close
       pop eax
       int 80h
  @@continue:
       add esp, _s4rq_size+4*4
       jmp @@wait_connection

  @@exit:
       mov ebx,ebp
       push __NR_close
       pop eax
       int 80h

       push exitmsg_size
       mov ecx, offset exitmsg
       pop edx
       call dbg_output

       push __NR_exit
       pop eax
       int 80h
start	endp



dbg_output proc
       push __NR_write
       push STDOUT
       pop ebx
       pop eax
       int 80h
       ret
dbg_output endp



cmd_connect proc
       push running_size
       mov ecx, offset running
       pop edx
       call dbg_output
       mov edx, [esp+s4rq_dstip+4*4]
       mov ax, [esp+s4rq_dstport+4*4]
       shl eax,16
       mov ax, 2

       push 0
       push 0
       push edx
       push eax

       push 6
       push 1
       push 2

       push __NR_socketcall
       pop eax
       push SYS_SOCKET
       pop ebx
       mov ecx,esp
       int 80h
       add esp,3*4
       mov esi,eax
       inc eax
       jz @@exit_goodbye

       mov eax,esp
       push 16
       push eax
       push esi

       push __NR_socketcall
       pop eax
       push SYS_CONNECT
       pop ebx
       mov ecx,esp
       int 80h
       add esp,3*4
       test eax,eax
       jnz @@exit

       push connected_size
       mov ecx, offset connected
       pop edx
       call dbg_output

       push SOCKS4_ACCESSGRANTED
       pop eax
       call send_reply

  @@redirect:
       push edi
       push esi

       mov ebx,edi
       cmp ebx,esi
       ja @@skip
       mov ebx,esi
  @@skip:
       inc ebx

       push 0
       bts [esp],edi
       bts [esp],esi
       mov ecx,esp

       push 0
       push 120
       mov edi,esp

       sub esi,esi
       sub eax,eax
       cdq
       mov al,__NR__newselect
       int 80h
       add esp,3*4
       pop esi
       pop edi
       test eax,eax
       jz @@exit
       inc eax
       jz @@exit

       mov eax,edi
       call check_socket
       jecxz @@exit3
       jc @@no_h2s

       push hacker2server_size
       mov ecx, offset hacker2server
       pop edx
       call dbg_output

       push edi
       push esi
       jmp @@do_rw

  @@no_h2s:
       mov eax,esi
       call check_socket
  @@exit3:
       jecxz @@exit
       jc @@redirect

       push server2hacker_size
       mov ecx, offset server2hacker
       pop edx
       call dbg_output

       push esi
       push edi

  @@do_rw:
       sub esp,4096
       mov ebp,esp

       push 0
       push 4096
       push ebp
       push dword ptr [esp+4096+4+3*4]

       push __NR_socketcall
       pop eax
       push SYS_RECV
       pop ebx
       mov ecx,esp
       int 80h
       add esp,4*4
       test eax,eax
       jz @@jmp2exit
       inc eax
       jz @@jmp2exit
       dec eax

       push 0
       push eax
       push ebp
       push dword ptr [esp+4096+3*4]

       push __NR_socketcall
       pop eax
       push SYS_SEND
       pop ebx
       mov ecx,esp
       int 80h
       add esp,4*4
       test eax,eax
       jz @@jmp2exit
       inc eax
       jz @@jmp2exit

  @@jmp2exit:
       add esp,4096
       test eax,eax
       jnz @@redirect

  @@exit:
       mov ebx,esi
       push __NR_close
       pop eax
       int 80h

  @@exit_goodbye:
       push SOCKS4_ACCESSDENIED
       pop eax
       call send_reply

       mov ebx,edi
       push __NR_close
       pop eax
       int 80h

       add esp, _s4rq_size+4*4+4*4

       push __NR_exit
       pop eax
       int 80h
cmd_connect endp



send_reply proc
       sub esp,_s4rp_size
       mov [esp+s4rp_cd],al
       mov byte ptr [esp+s4rp_vn],SOCKS4_REPLY_VERSION

       mov eax,esp
       push 0
       push _s4rp_size
       push eax
       push edi

       push __NR_socketcall
       pop eax
       push SYS_SEND
       pop ebx
       mov ecx,esp
       int 80h

       add esp,_s4rp_size+4*4
       ret
send_reply endp



check_socket proc
       mov cl, 1
       pushad

       push 0
       bts [esp],eax
       mov ecx,esp
       lea ebx,[eax+1]

       push 0
       push 0
       mov edi,esp

       sub esi,esi

       sub eax,eax
       cdq
       mov al,__NR__newselect
       int 80h
       add esp,3*4
       test eax,eax
       jz @@socket_empty
       dec eax
       jz @@socket_full

       mov dword ptr [esp+6*4],0

  @@socket_full:
       db 0a8h				;test al,?
  @@socket_empty:
       stc

       popad
       ret
check_socket endp

end start
