;ELF LINKER FOR TASM/MASM
;(c) Vecna 2004
;
;This is the linux version of the linker. It is responsible for parsing the
;commandline, loading the OBJ in memory and then call our linking routines.
;After they return, this code save the output filename and change it to +x.

bits 32

%include "inc/header.inc"
%include "inc/syscall.inc"

%include "omfcoff.asi"

_start:
       push by copyright_size
       mov ecx, copyright
       pop edx
       call console_output

       pop eax
       sub al,3
       pop eax
       jnz near .usage

       pop ebx
       pop eax
       mov [outfile],eax

       push by __NR_open
       pop eax
       push by O_RDONLY
       pop ecx
       int 80h
       test eax,eax
       js .js2error
       mov ebx,eax

       push by __NR_lseek
       pop eax
       push by 0
       pop ecx
       push by SEEK_END
       pop edx
       int 80h
       mov [infile_size],eax

       push by __NR_lseek
       pop eax
       push by 0
       pop ecx
       push by SEEK_SET
       pop edx
       int 80h

       mov eax,[infile_size]
       call malloc
       mov [infile_buffer],eax

       push by __NR_read
       pop eax
       mov ecx,[infile_buffer]
       mov edx,[infile_size]
       int 80h

       push by __NR_close
       pop eax
       int 80h

       push dwo [infile_size]
       push dwo [infile_buffer]
       call obj2elf
       mov [outfile_buffer],edx
       mov [outfile_size],eax

       push by __NR_open
       pop eax
       mov ebx,[outfile]
       mov ecx,O_WRONLY+O_CREAT+O_TRUNC
       mov edx,S_IREAD+S_IEXEC+S_IRGRP+S_IXGRP
       int 80h
       mov ebx,eax
       test eax,eax
  .js2error:
       js .error

       push by __NR_write
       pop eax
       mov ecx,[outfile_buffer]
       mov edx,[outfile_size]
       int 80h

       push by __NR_close
       pop eax
       int 80h

  .done:
       push by exitmsg_size
       mov ecx, exitmsg
  .exit:
       pop edx
       call console_output
       jmp phdr.finish

  .usage:
       push by usage_size
       mov ecx, usage
       jmps .exit

  .error:
       push by error_size
       mov ecx, error
       jmps .exit


console_output:
       push by __NR_write
       push by 1
       pop ebx
       pop eax
       int 80h
       ret


malloc:
       pushad

       push by __NR_brk
       pop eax
       sub ebx,ebx
       int 80h

       mov ecx,[esp+_Pushad_eax]
       mov [esp+_Pushad_eax],eax
       add eax,ecx

       push by __NR_brk
       pop ebx
       xchg eax,ebx
       int 80h

       popad
       ret


;size
;buffer
obj2elf:
	pushad

        mov eax,64*1024
        call malloc
        mov [esp+_Pushad_edx],eax

        sub edi,edi
        xchg eax,edi
        push edi
        mov ecx,64*1024/4
        rep stosd
        pop edi

	mov esi,[esp+_Pushad+param1]
	mov ecx,[esp+_Pushad+param2]
  .coff:
	call link_omf_coff			;microsoft coff
	mov [esp+_Pushad_eax],eax
	popad
	ret 2*4

copyright db "LINKER v0.1",10
	  db "(c) Vecna 2003",10
copyright_size equ $-copyright

usage db "USAGE: link <objfile> <elffile>",10,10
usage_size equ $-usage

error db "Error processing files...",10,10
error_size equ $-error

exitmsg db "Done!",10,10
exitmsg_size equ $-exitmsg


infile_size dd 0
infile_buffer dd 0

outfile_size dd 0
outfile_buffer dd 0
outfile dd 0


filesize equ $-$$
memsize	 equ $ - origin

