/*
  (x) uNdErX 2003 - <underx@antisocial.com>

  MLDE32 Table Packer

*/

#include <stdio.h>
#include <stdlib.h>

#include "table.h"

char *types[13] = {"O_UNIQUE","O_PREFIX","O_IMM8","O_IMM16","O_IMM24","O_IMM32","O_IMM48",
                   "O_MODRM","O_MODRM8","O_MODRM32","O_EXTENDED","O_WEIRD","O_ERROR"};

BYTE mlde32_gettype(void *code, void *table)
{
  BYTE type;
  asm
  {
    cld
    mov  esi, [code]
    mov  edi, [table]
  @@go:
    lodsb
  @@ft:
    mov  ah, [edi]
    inc  edi
    shr  ah, 4
    sub  al, ah
    jnc  @@ft

    mov  al, [edi-1]
    and  al, 0Fh

    mov  type, al
  }
  return type;
}

BYTE pack_table(BYTE *table, BYTE *outbuf)
{
  BYTE b = 0;
  BYTE i = 0, k = 0, r = -1;

  BYTE c1 = table[i]&0x0F, c2;

  do
  {
    do
    {
      if(r == (1<<4)-1) break;

      r++;

      if(b)
        c2 = table[i++]&0x0F;
      else
        c2 = table[i]>>4;

      b = !b;
    }
    while(c1 == c2);

    outbuf[k++] = ((r<<4)|(c1));

    c1 = c2; r = 0;
  }
  while( i <= 128 );

  return k;
}

int main(void)
{
  printf("; MLDE32 Table Packer - (x) uNdErX 2003\n");

  BYTE k, r, e1, e2;
  BYTE outbuf[200] = {0};

  e1 = pack_table(&ttbl[0], &outbuf[0]);
  e2 = pack_table(&etbl[0], &outbuf[e1]);

  // verify generated table with mlde32 depack code
  for(int i = 0; i <= 255; i++)
  {
    k = mlde32_gettype(&i, &outbuf[0]); // normal opcodes

    if(i&1)
      r = ttbl[i>>1]&0x0F;
    else
      r = ttbl[i>>1]>>4;

    if(k != r)
    {
      printf("Normal Opcode Table was not packed correctly!\n"\
             "Opcode       : %02X\n"\
             "Table Byte   : %02X\n"\
             "Found type   : %s (%02X)\n"\
             "Original type: %s (%02X)\n", i, outbuf[i], types[k], k, types[r], r);
      exit(1);
    }

    k = mlde32_gettype(&i, &outbuf[e1]); //extended ones

    if(i&1)
      r = etbl[i>>1]&0x0F;
    else
      r = etbl[i>>1]>>4;

    if(k != r)
    {
      printf("Extended Opcode Table was not packed correctly!\n"\
             "Opcode       : 0F %02X\n"\
             "Table Byte   : %02X\n"\
             "Found type   : %s (%02X)\n"\
             "Original type: %s (%02X)\n", i, outbuf[e1+i], types[k], k, types[r], r);
      exit(2);
    }
  }
  
  e1--; e2--;

  printf("; The Entire Packed Table has %d bytes.\n", e1+e2);
  printf("; Normal table has %d bytes and Extended table has %d bytes.\n", e1, e2);
  printf("; Generated code has %d bytes.\n\n", ((e1+e2)/4)*5 );

  int i, j;
  BYTE revbuf[200] = {0};

  for(i = (e1+e2), j = 0; i >= 0; i--, j++) revbuf[j] = outbuf[i];

  for(i = 0; i <= (e1+e2); i+=4)
    printf("       push 0%08Xh\n", ((revbuf[i]<<24)|(revbuf[i+1]<<16)|(revbuf[i+2]<<8)|(revbuf[i+3])));

  return 0;
}
