#ifndef _ObjInstance_C_
#define _ObjInstance_C_

#include "ObjInstance.h"

extern "C" {
#include <gif_lib.h>
}
extern GifColorType TRANSPARENCY_COLOR;  //is (1,254,1) used as transparent color

int minimum(int a,int b) {return ((a)>(b))?(b):(a);}
int maximum(int a,int b) {return ((a)<(b))?(b):(a);}


/*
 during drawing x_pos,y_pos are members of the instance,
 x_size,y_size,Image,point_inside_LS() are members of the object type
*/

int GObjInstance::Draw(LScreen *ls)
{
  //paint the Image part inside the screen
  int x,y;
  int x_A,y_A,x_B,y_B;  //{A=(right,left)},{B=(down+1,right+1)} corners of the effective box to paint
  int x_size=obj_ref->x_size,
      y_size=obj_ref->y_size;
  if (obj_ref->Image==NULL || ls==NULL )
      return -1; //nothing to paint
  
  x_B=minimum(ls->x_size,x_pos+x_size);
  y_B=minimum(ls->y_size,y_pos+y_size);
  x_A=maximum(0,x_pos);
  y_A=maximum(0,y_pos);
//  printf("(x_A,y_A)=(%d,%d)\n(x_B,y_B)=(%d,%d)\n",x_A,y_A,x_B,y_B);

  for(x=x_A;x<x_B;x++)
    for(y=y_A;y<y_B;y++)
    {
      // look at transparent background
      if((*(obj_ref->Image+3*((x-x_pos)+(y-y_pos)*x_size))==TRANSPARENCY_COLOR.Red) &&
         (*(obj_ref->Image+3*((x-x_pos)+(y-y_pos)*x_size)+1)==TRANSPARENCY_COLOR.Green) &&
         (*(obj_ref->Image+3*((x-x_pos)+(y-y_pos)*x_size)+2)==TRANSPARENCY_COLOR.Blue))
           continue;  //skip the transparent color (dirty joke)
          
      *(ls->image+3*(x+(y*ls->x_size)))=
           *(obj_ref->Image+3*((x-x_pos)+(y-y_pos)*x_size));
      *(ls->image+3*(x+(y*ls->x_size))+1)=
           *(obj_ref->Image+3*((x-x_pos)+(y-y_pos)*x_size)+1);
      *(ls->image+3*(x+(y*ls->x_size))+2)=
          *(obj_ref->Image+3*((x-x_pos)+(y-y_pos)*x_size)+2);
    }
  
  return 0;
}



#endif
