.data

opcode_table dd ofs nop_jmp
             dd ofs opcodes1
             dd ofs emul_mov_imm
             dd ofs sub_add_imm
             dd ofs math_imm
             dd ofs emul_jx
             dd ofs emul_cxi
             dd ofs emul_mbpc
             dd ofs emul_mm
             dd ofs emul_mathm
             dd ofs emul_pushpop
             dd ofs emul_shift
             dd ofs not_implemented
             dd ofs not_implemented
             dd ofs not_implemented
             dd ofs not_implemented

mathm dd ofs emul_madd
      dd ofs emul_madc
      dd ofs emul_msub
      dd ofs emul_msbb
      dd ofs emul_mxor
      dd ofs emul_mor
      dd ofs emul_mand
      dd ofs emul_mnot

opcode_simple dd ofs emul_ret
              dd ofs emul_ca
              dd ofs emul_cstkprca
              dd ofs emul_a_is_0

sub_add dd ofs emul_sai
        dd ofs emul_sbai
        dd ofs emul_adai
        dd ofs emul_adcai

math_a dd ofs emul_xai
       dd ofs emul_oai
       dd ofs emul_aai
       dd ofs emul_na

.data?

base  dd ?                      ;this get added to b mem operations
input dd ?
stack dd ?

stk   db ?
      db ?,?,?
a     db ?
      db ?,?,?
zero  db ?
      db ?,?,?
carry db ?
      db ?,?,?

b     dd ?
pc    dd ?

.code

;param=memory(64*1024 bytes)
;param=stack memory(256 dwords)
;param=code stream
start_cpu:
       pushad
       mov eax,[esp.cPushad.Arg1]
       mov [input],eax
       mov eax,[esp.cPushad.Arg2]
       mov [stack],eax
       mov eax,[esp.cPushad.Arg3]
       mov [base],eax

       sub eax,eax
       mov by [stk],-1
       mov [a],al
       ;zero and carry are undefinited
       mov [b],eax
       mov [pc],eax

       popad
       ret 3*Pshd

;param=number of bits to return
get_bits:
       pushad
       mov eax,[pc]
       mov ecx,eax

       and ecx,0111b
       shr eax,3

       mov ebx,[input]
       mov edx,[ebx+eax+4]
       mov eax,[ebx+eax]
       jecxz @@norotate
  @@rotate:
       shr eax,1
       shr edx,1
       jnc @@noset
       bts eax,31
  @@noset:
       loop @@rotate
  @@norotate:

       mov ecx,[esp.cPushad.Arg1]
       add [pc],ecx

       sub edx,edx
  @@build_mask:
       rol edx,1
       or edx,1
       loop @@build_mask

       and eax,edx

       mov [esp.Pushad_eax],eax
       popad
       ret Pshd

get_sd2:
       call get_sd
       push eax
       call get_sd
       pop ecx
       ret

;ofs A;ofs B;ofs PC;immediate
get_sd:
       pushad
       push 2
       call get_bits
       test eax,eax
       jnz @@no_a
       lea eax,[a]
       jmp @@done

  @@no_a:
       dec eax
       jnz @@no_b
       lea eax,[b]
       jmp @@done

  @@no_b:
       dec eax
       jnz @@no_pc
       lea eax,[pc]
       jmp @@done

  @@no_pc:
       ;md
       push 2
       call get_bits
       test eax,eax
       jnz @@no_imm
       push 32
       call get_bits
       jmp @@done

  @@no_imm:
       dec eax
       jnz @@no_stack_a
       movzx eax,by [a]
       shl eax,2
       add eax,[stack]
       jmp @@done

  @@no_stack_a:
       dec eax
       jz @@add2b
       ;[b+a]
       movzx eax,by [a]
  @@add2b:
       add eax,[b]
       add eax,[base]

  @@done:
       mov [esp.Pushad_eax],eax
       popad
       ret

emul_opcode:
       push 4
       call get_bits
       jmp [ofs opcode_table+eax*4]

not_implemented:
       int 3
       jmp $

_pop:
       push ecx
       mov eax,[stack]
       movzx ecx,by [stk]
       inc by [stk]
       mov eax,[eax+ecx*4]      ;POP eax
       pop ecx
       ret

_push:
       push edx
       dec by [stk]
       movzx edx,by [stk]
       shl edx,2
       add edx,[stack]
       mov [edx],eax
       pop edx
       ret

nop_jmp:
       push 1
       pop ecx
       push 1
       call get_bits
       dec eax
       jz __skip_jx

emul_nop:
       ret

opcodes1:
       push 2
       call get_bits
       jmp [ofs opcode_simple+eax*4]

emul_ret:
       call _pop
       mov [pc],eax                     ;pc=(dword)stack[(byte)stk++]
       ret

emul_ca:
       mov eax,[pc]
       call _push                       ;stack[(byte)--stk]=pc

       movzx eax,by [a]
       shl eax,2
       add eax,[stack]
       mov eax,[eax]

       mov [pc],eax                     ;pc=stack[(byte)a]
       ret

emul_cstkprca:
       ;***
       jmp not_implemented

emul_a_is_0:
       movzx eax,by [a]
       test eax,eax
       jz @@is_zero
       push -1
       pop eax
  @@is_zero:
       inc eax
       mov by [zero],al                 ;zero=(a==0)1?0
       ret

emul_mov_imm:
       push 1
       call get_bits
       dec eax
       jz emul_mbi

emul_mai:
       push 8
       call get_bits
       mov [a],al
       ret

emul_mbi:
       push 32
       call get_bits
       mov [b],eax
       ret

sub_add_imm:
       push 2
       call get_bits
       jmp [ofs sub_add+eax*4]

emul_sai:
       push 8
       call get_bits                   ;a-=*pc++
       sub by [a],al
       jmp __flags

emul_sbai:
       push 8
       call get_bits                   ;a-=*pc++
       sub by [a],al

       cmp by [carry],1                 ;if(carry)a--
       jz @@skip
       dec by [a]
  @@skip:
       jmp __flags

emul_adai:
       push 8
       call get_bits                   ;a+=*pc++
       add by [a],al
       jmp __flags

emul_adcai:
       push 8
       call get_bits                   ;a+=*pc++
       add by [a],al

       cmp by [carry],1
       jz @@skip                        ;if(carry)a++
       inc by [a]
  @@skip:
       jmp __flags

math_imm:
       push 2
       call get_bits
       jmp [ofs math_a+eax*4]

emul_xai:
       push 8
       call get_bits                   ;a^=*pc++
       xor by [a],al
       jmp __flags

emul_oai:
       push 8
       call get_bits                   ;a|=*pc++
       or by [a],al
       jmp __flags

emul_aai:
       push 8
       call get_bits                   ;a&=*pc++
       and by [a],al
       jmp __flags

emul_na:
       not by [a]                       ;!a
       jmp __flags

emul_jx:
       push 1
       call get_bits
       dec eax
       jz emul_jc

emul_jz:
       movzx ecx,by [zero]
       jmp __skip_jx

emul_jc:
       movzx ecx,by [carry]             ;Y=carry

  __skip_jx:
       push 11
       call get_bits                   ;X=pc++

       jecxz __done_jx                  ;if(Y)

       btr eax,10
       jnc @@addpc
       or eax, 11111111111111111111110000000000b
              ;1111 1111 1111 1111 1111 1100 0000 0000
  @@addpc:
       add [pc],eax                     ;pc+=(signed)X

  __done_jx:
       ret

emul_cxi:
       push 1
       call get_bits
       dec eax
       jz emul_cbi

emul_cai:
       push 8
       movzx ecx, by [a]
       jmp __flgs2

emul_cbi:
       push 32
       mov ecx,[b]

  __flgs2:
       call get_bits                   ;zero=(b==*pc++)1?0 / carry=(b<*pc++)1?0
       sub ecx,eax

  __flags:
       mov al,0
       jnz @@skip_z                     ;zero=(X)1?0
       mov al,1
  @@skip_z:
       mov by [zero],al

       mov al,0
       jnc @@skip_c                     ;carry=(X)1?0
       mov al,1
  @@skip_c:
       mov by [carry],al

       ret

emul_mbpc:
       mov eax,[pc]
       mov [b],eax                       ;b=pc;
       ret


emul_pushpop:
       push 1
       call get_bits
       dec eax
       jz @@pop
  @@push:
       call get_sd
       mov eax,[eax]
       call _push
       ret
  @@pop:
       call get_sd
       push eax
       call _pop        ;ofs A;ofs B;ofs PC;immediate
       pop ecx
       mov [ecx],eax
       ret

emul_shift:
int 3
       push ofs __flags

       push 1
       call get_bits
       dec eax
       jz @@shl
  @@shr:
       call get_sd
       shr dwo [eax],1
       ret
  @@shl:
       call get_sd
       shl dwo [eax],1
       ret

emul_mm:
       call get_sd2
       mov eax,[eax]
       mov [ecx],eax
       ret

emul_mathm:
       push ofs __flags

       push 3
       call get_bits
       jmp [ofs mathm+eax*4]

emul_mnot:
       call get_sd
       not dwo [eax]
       ret

emul_madd:
       call get_sd2
       mov eax,[eax]
       add [ecx],eax
       ret

emul_msub:
       call get_sd2
       mov eax,[eax]
       sub [ecx],eax
       ret


emul_mxor:
       call get_sd2
       mov eax,[eax]
       xor [ecx],eax
       ret

emul_mor:
       call get_sd2
       mov eax,[eax]
       or [ecx],eax
       ret


emul_mand:
       call get_sd2
       mov eax,[eax]
       and [ecx],eax
       ret

emul_madc:
       call emul_madd
       cmp by [carry],1
       jz @@skip
       inc dwo [ecx]
  @@skip:
       ret

emul_msbb:
       call emul_msub
       cmp by [carry],1
       jz @@skip
       dec dwo [ecx]
  @@skip:
       ret
