; MD4 in x86 ASM
;
; Last modified: May 2003 - bcom@hushmail.com
;

FF	macro	dwA, dwB, dwC, dwD, dwX, rS
 	
	mov	edi, dwC
	mov	ebp, [dwX]

	xor	edi, dwD
	and	edi, dwB
	xor	edi, dwD
		
	lea	dwA, [ebp + dwA]
	add	dwA, edi
	rol	dwA, rS
endm

FFMOD	macro	dwA, dwB, dwC, dwD, rS
	
	mov	edi, dwC
	
	xor	edi, dwD
	and	edi, dwB
	xor	edi, dwD
	
	lea	dwA, [dwA + edi]
	rol	dwA, rS
ENDM
GG	macro	dwA, dwB, dwC, dwD, dwX, rS, dwT	; ebx = X, ecx = Y, edx = Z

	mov	edi, dwC		; edi = Y
	and	edi, dwD		; Y & Z
	mov	ebp, dwB		; ebp = X
	and	ebp, dwC		; X & Y
	or	edi, ebp		; (Y & Z) | (X & Y)
	;-------------
	mov	ebp, dwB		; ebp = X
	and	ebp, dwD		; (X & Z)
	or	edi, ebp		; ((Y & Z) | (X & Y)) | (X & Z)

	mov	ebp, [dwX]

	lea	dwA, [ebp + dwA + dwT]
	add	dwA, edi
	rol	dwA, rS
endm

GGMOD	macro	dwA, dwB, dwC, dwD, rS, dwT
	
	mov	edi, dwC		; edi = Y
	and	edi, dwD		; Y & Z
	mov	ebp, dwB		; ebp = X
	and	ebp, dwC		; X & Y
	or	edi, ebp		; (Y & Z) | (X & Y)
	;-------------
	mov	ebp, dwB		; ebp = X
	and	ebp, dwD		; (X & Z)
	or	edi, ebp		; ((Y & Z) | (X & Y)) | (X & Z)

	lea	dwA, [dwA + edi + dwT]
	rol	dwA, rS
ENDM

HH	macro	dwA, dwB, dwC, dwD, dwX, rS, dwT

	mov	edi, dwB
	mov	ebp, [dwX]

	xor	edi, dwC
	xor	edi, dwD
	
	lea	dwA, [ebp + dwA + dwT]
	add	dwA, edi
	rol	dwA, rS
endm

HHMOD	macro	dwA, dwB, dwC, dwD, rS, dwT
	
	mov	edi, dwB
	xor	edi, dwC
	xor	edi, dwD
	
	lea	dwA, [dwA + edi + dwT]
	rol	dwA, rS
ENDM
.code

MD4:
	mov	[edi_], edi
	mov	[ebp_], ebp

	mov	esi,  [esp + (03 * 04)]

	mov	eax, 067452301h
	mov	ebx, 0efcdab89h
	mov	ecx, 098badcfeh
	mov	edx, 010325476h
	
	;==================================================

	FF	eax, ebx, ecx, edx, esi+(00*4), 03
	FF	edx, eax, ebx, ecx, esi+(01*4), 07
	FF	ecx, edx, eax, ebx, esi+(02*4), 11
	FF	ebx, ecx, edx, eax, esi+(03*4), 19
	
	FFMOD	eax, ebx, ecx, edx,		  03 
	FFMOD	edx, eax, ebx, ecx,		  07 
	FFMOD	ecx, edx, eax, ebx,		  11 
	FFMOD	ebx, ecx, edx, eax,		  19 
	
	FFMOD	eax, ebx, ecx, edx, 		  03 
	FFMOD	edx, eax, ebx, ecx, 		  07 
	FFMOD	ecx, edx, eax, ebx, 		  11 
	FFMOD	ebx, ecx, edx, eax, 		  19 

	FFMOD	eax, ebx, ecx, edx, 		  03 
	FFMOD	edx, eax, ebx, ecx, 		  07 
	FF	ecx, edx, eax, ebx, esi+(14*4), 11 
	FFMOD	ebx, ecx, edx, eax, 		  19 
	
	;==================================================

	GG	eax, ebx, ecx, edx, esi+(00*4), 03, 05a827999h
	GGMOD	edx, eax, ebx, ecx, 		  05, 05a827999h 
	GGMOD	ecx, edx, eax, ebx, 		  09, 05a827999h 
	GGMOD	ebx, ecx, edx, eax, 		  13, 05a827999h 
	
	GG	eax, ebx, ecx, edx, esi+(01*4), 03, 05a827999h
	GGMOD	edx, eax, ebx, ecx, 		  05, 05a827999h
	GGMOD	ecx, edx, eax, ebx, 		  09, 05a827999h
	GGMOD	ebx, ecx, edx, eax, 		  13, 05a827999h

	GGMOD	eax, ebx, ecx, edx, 		  03, 05a827999h
	GGMOD	edx, eax, ebx, ecx, 		  05, 05a827999h
	GGMOD	ecx, edx, eax, ebx, 		  09, 05a827999h
	GG	ebx, ecx, edx, eax, esi+(14*4), 13, 05a827999h

	GG	eax, ebx, ecx, edx, esi+(03*4), 03, 05a827999h
	GGMOD	edx, eax, ebx, ecx, 		  05, 05a827999h
	GGMOD	ecx, edx, eax, ebx, 		  09, 05a827999h
	GGMOD	ebx, ecx, edx, eax, 		  13, 05a827999h

	;==================================================

	HH	eax, ebx, ecx, edx, esi+(00*4), 03, 06ed9eba1h
	HHMOD	edx, eax, ebx, ecx, 		  09, 06ed9eba1h
	HHMOD	ecx, edx, eax, ebx, 		  11, 06ed9eba1h
	HHMOD	ebx, ecx, edx, eax, 		  15, 06ed9eba1h
	
	HH	eax, ebx, ecx, edx, esi+(02*4), 03, 06ed9eba1h
	HHMOD	edx, eax, ebx, ecx, 		  09, 06ed9eba1h
	HHMOD	ecx, edx, eax, ebx, 		  11, 06ed9eba1h
	HH	ebx, ecx, edx, eax, esi+(14*4), 15, 06ed9eba1h

	HH	eax, ebx, ecx, edx, esi+(01*4), 03, 06ed9eba1h
	HHMOD	edx, eax, ebx, ecx, 		  09, 06ed9eba1h
	HHMOD	ecx, edx, eax, ebx, 		  11, 06ed9eba1h
	HHMOD	ebx, ecx, edx, eax, 		  15, 06ed9eba1h

	HH	eax, ebx, ecx, edx, esi+(03*4), 03, 06ed9eba1h
	HHMOD	edx, eax, ebx, ecx, 		  09, 06ed9eba1h
	HHMOD	ecx, edx, eax, ebx, 		  11, 06ed9eba1h
	HHMOD	ebx, ecx, edx, eax, 		  15, 06ed9eba1h

	;==================================================

	add	eax, 067452301h
	add	ebx, 0efcdab89h
	add	ecx, 098badcfeh
	add	edx, 010325476h
	
	mov	edi, [edi_]
	mov	ebp, [ebp_]

	retn	(01 * 04)