; SHA-1 in x86 ASM
;
; Last modified May 2003 - bcom@hushmail.com
;
.data
	align 4
reg_temp	dd	0
szDigest	db	320	dup	(0)


fast_copy	macro	pDest, pSrc
	mov	eax, [pSrc]
	bswap	eax
	mov	[pDest], eax
ENDM

fast_expand	macro	pBuffy
	lea	ebx, [pBuffy]
	mov eax, [ebx - (03 * 04)]
	xor eax, [ebx - (08 * 04)]
	xor eax, [ebx - (14 * 04)]
	xor eax, [ebx - (16 * 04)]
	rol eax, 1
	mov dword ptr [ebx], eax
ENDM

FAST_EXPANDMSG	macro
	fast_copy	edi+(00*04), esi+(00*04)
	fast_copy	edi+(01*04), esi+(01*04)
	fast_copy	edi+(02*04), esi+(02*04)
	fast_copy	edi+(03*04), esi+(03*04)
	;-----------------------------------
IFDEF MORE_THAN_FIFTEEN
	fast_copy	edi+(04*04), esi+(04*04)
	fast_copy	edi+(05*04), esi+(05*04)
	fast_copy	edi+(06*04), esi+(06*04)
	fast_copy	edi+(07*04), esi+(07*04)
	;-----------------------------------
	fast_copy	edi+(08*04), esi+(08*04)
	fast_copy	edi+(09*04), esi+(09*04)
	fast_copy	edi+(10*04), esi+(10*04)
	fast_copy	edi+(11*04), esi+(11*04)
	;-----------------------------------
	fast_copy	edi+(12*04), esi+(12*04)
	fast_copy	edi+(13*04), esi+(13*04)
	fast_copy	edi+(14*04), esi+(14*04)
ENDIF
	fast_copy	edi+(15*04), esi+(15*04)
;-----------------------------------------
	lea	edi, [edi + 64]
@expand:
	fast_expand	edi+(00*04)
	fast_expand	edi+(01*04)
	fast_expand	edi+(02*04)
	fast_expand	edi+(03*04)
	fast_expand	edi+(04*04)
	fast_expand	edi+(05*04)
	fast_expand	edi+(06*04)
	fast_expand	edi+(07*04)
	fast_expand	edi+(08*04)
	fast_expand	edi+(09*04)
	fast_expand	edi+(10*04)
	fast_expand	edi+(11*04)
	fast_expand	edi+(12*04)
	fast_expand	edi+(13*04)
	fast_expand	edi+(14*04)
	fast_expand	edi+(15*04)
	;----------------------	
	fast_expand	edi+(16*04)
	fast_expand	edi+(17*04)
	fast_expand	edi+(18*04)
	fast_expand	edi+(19*04)
	fast_expand	edi+(20*04)
	fast_expand	edi+(21*04)
	fast_expand	edi+(22*04)
	fast_expand	edi+(23*04)
	fast_expand	edi+(24*04)
	fast_expand	edi+(25*04)
	fast_expand	edi+(26*04)
	fast_expand	edi+(27*04)
	fast_expand	edi+(28*04)
	fast_expand	edi+(29*04)
	fast_expand	edi+(30*04)
	fast_expand	edi+(31*04)
	;----------------------	
	fast_expand	edi+(32*04)
	fast_expand	edi+(33*04)
	fast_expand	edi+(34*04)
	fast_expand	edi+(35*04)
	fast_expand	edi+(36*04)
	fast_expand	edi+(37*04)
	fast_expand	edi+(38*04)
	fast_expand	edi+(39*04)
	fast_expand	edi+(40*04)
	fast_expand	edi+(41*04)
	fast_expand	edi+(42*04)
	fast_expand	edi+(43*04)
	fast_expand	edi+(44*04)
	fast_expand	edi+(45*04)
	fast_expand	edi+(46*04)
	fast_expand	edi+(47*04)
	;----------------------	
	fast_expand	edi+(48*04)
	fast_expand	edi+(49*04)
	fast_expand	edi+(50*04)
	fast_expand	edi+(51*04)
	fast_expand	edi+(52*04)
	fast_expand	edi+(53*04)
	fast_expand	edi+(54*04)
	fast_expand	edi+(55*04)
	fast_expand	edi+(56*04)
	fast_expand	edi+(57*04)
	fast_expand	edi+(58*04)
	fast_expand	edi+(59*04)
	fast_expand	edi+(60*04)
	fast_expand	edi+(61*04)
	fast_expand	edi+(62*04)
	fast_expand	edi+(63*04)
	;----------------------	
ENDM

SHA0	macro	dwA, dwB, dwC, dwD, dwE, dwW, dwK
	mov	edi, dwC

	xor	edi, dwD
	and	edi, dwB
	xor	edi, dwD
	
	lea	dwE, [dwE + dwK + edi]
	mov	edi, dwA
	rol	edi, 05
	add	dwE, [dwW]
	add	dwE, edi
	rol	dwB, 30
ENDM

SHA2	macro	dwA, dwB, dwC, dwD, dwE, dwW, dwK
	mov	edi, dwC

	xor	edi, dwD
	xor	edi, dwB
	
	lea	dwE, [dwE + dwK + edi]
	mov	edi, dwA
	rol	edi, 05
	add	dwE, [dwW]
	add	dwE, edi
	rol	dwB, 30
ENDM

SHA3	macro	dwA, dwB, dwC, dwD, dwE, dwW, dwK

	mov	[reg_temp], ebp

	mov	edi, dwC
	and	edi, dwD
	mov	ebp, dwB
	and	ebp, dwC
	or	edi, ebp
	;-------------
	mov	ebp, dwB
	and	ebp, dwD
	or	edi, ebp
	
	mov	ebp, [reg_temp]
	
	lea	dwE, [dwE + dwK + edi]
	mov	edi, dwA
	rol	edi, 05
	add	dwE, [dwW]
	add	dwE, edi
	rol	dwB, 30
ENDM

SHA4	macro	dwA, dwB, dwC, dwD, dwE, dwW, dwK
	mov	edi, dwC

	xor	edi, dwD
	xor	edi, dwB
	
	lea	dwE, [dwE + dwK + edi]
	mov	edi, dwA
	rol	edi, 05
	add	dwE, [dwW]
	add	dwE, edi
	rol	dwB, 30
ENDM
.code
	align 4
SHA1:
	mov	[edi_], edi
	mov	[ebp_], ebp
	
	mov	esi, [esp + (03 * 04)]
	mov	edi, offset szDigest

	FAST_EXPANDMSG
	
	mov	eax, 067452301h
	mov	ebx, 0efcdab89h
	mov	ecx, 098badcfeh
	mov	edx, 010325476h
	mov	esi, 0c3d2e1f0h

	mov	ebp, offset szDigest
	;=====================================================

	SHA0	eax, ebx, ecx, edx, esi, ebp+(00*04), 05a827999h
	SHA0	esi, eax, ebx, ecx, edx, ebp+(01*04), 05a827999h
	SHA0	edx, esi, eax, ebx, ecx, ebp+(02*04), 05a827999h
	SHA0	ecx, edx, esi, eax, ebx, ebp+(03*04), 05a827999h
	SHA0	ebx, ecx, edx, esi, eax, ebp+(04*04), 05a827999h
	
	SHA0	eax, ebx, ecx, edx, esi, ebp+(05*04), 05a827999h
	SHA0	esi, eax, ebx, ecx, edx, ebp+(06*04), 05a827999h
	SHA0	edx, esi, eax, ebx, ecx, ebp+(07*04), 05a827999h
	SHA0	ecx, edx, esi, eax, ebx, ebp+(08*04), 05a827999h
	SHA0	ebx, ecx, edx, esi, eax, ebp+(09*04), 05a827999h

	SHA0	eax, ebx, ecx, edx, esi, ebp+(10*04), 05a827999h
	SHA0	esi, eax, ebx, ecx, edx, ebp+(11*04), 05a827999h
	SHA0	edx, esi, eax, ebx, ecx, ebp+(12*04), 05a827999h
	SHA0	ecx, edx, esi, eax, ebx, ebp+(13*04), 05a827999h
	SHA0	ebx, ecx, edx, esi, eax, ebp+(14*04), 05a827999h

	SHA0	eax, ebx, ecx, edx, esi, ebp+(15*04), 05a827999h
	SHA0	esi, eax, ebx, ecx, edx, ebp+(16*04), 05a827999h
	SHA0	edx, esi, eax, ebx, ecx, ebp+(17*04), 05a827999h
	SHA0	ecx, edx, esi, eax, ebx, ebp+(18*04), 05a827999h
	SHA0	ebx, ecx, edx, esi, eax, ebp+(19*04), 05a827999h

	;=====================================================

	SHA2	eax, ebx, ecx, edx, esi, ebp+(20*04), 06ed9eba1h
	SHA2	esi, eax, ebx, ecx, edx, ebp+(21*04), 06ed9eba1h
	SHA2	edx, esi, eax, ebx, ecx, ebp+(22*04), 06ed9eba1h
	SHA2	ecx, edx, esi, eax, ebx, ebp+(23*04), 06ed9eba1h
	SHA2	ebx, ecx, edx, esi, eax, ebp+(24*04), 06ed9eba1h

	SHA2	eax, ebx, ecx, edx, esi, ebp+(25*04), 06ed9eba1h
	SHA2	esi, eax, ebx, ecx, edx, ebp+(26*04), 06ed9eba1h
	SHA2	edx, esi, eax, ebx, ecx, ebp+(27*04), 06ed9eba1h
	SHA2	ecx, edx, esi, eax, ebx, ebp+(28*04), 06ed9eba1h
	SHA2	ebx, ecx, edx, esi, eax, ebp+(29*04), 06ed9eba1h

	SHA2	eax, ebx, ecx, edx, esi, ebp+(30*04), 06ed9eba1h
	SHA2	esi, eax, ebx, ecx, edx, ebp+(31*04), 06ed9eba1h
	SHA2	edx, esi, eax, ebx, ecx, ebp+(32*04), 06ed9eba1h
	SHA2	ecx, edx, esi, eax, ebx, ebp+(33*04), 06ed9eba1h
	SHA2	ebx, ecx, edx, esi, eax, ebp+(34*04), 06ed9eba1h

	SHA2	eax, ebx, ecx, edx, esi, ebp+(35*04), 06ed9eba1h
	SHA2	esi, eax, ebx, ecx, edx, ebp+(36*04), 06ed9eba1h
	SHA2	edx, esi, eax, ebx, ecx, ebp+(37*04), 06ed9eba1h
	SHA2	ecx, edx, esi, eax, ebx, ebp+(38*04), 06ed9eba1h
	SHA2	ebx, ecx, edx, esi, eax, ebp+(39*04), 06ed9eba1h

	;=====================================================

	SHA3	eax, ebx, ecx, edx, esi, ebp+(40*04), 08f1bbcdch
	SHA3	esi, eax, ebx, ecx, edx, ebp+(41*04), 08f1bbcdch
	SHA3	edx, esi, eax, ebx, ecx, ebp+(42*04), 08f1bbcdch
	SHA3	ecx, edx, esi, eax, ebx, ebp+(43*04), 08f1bbcdch
	SHA3	ebx, ecx, edx, esi, eax, ebp+(44*04), 08f1bbcdch

	SHA3	eax, ebx, ecx, edx, esi, ebp+(45*04), 08f1bbcdch
	SHA3	esi, eax, ebx, ecx, edx, ebp+(46*04), 08f1bbcdch
	SHA3	edx, esi, eax, ebx, ecx, ebp+(47*04), 08f1bbcdch
	SHA3	ecx, edx, esi, eax, ebx, ebp+(48*04), 08f1bbcdch
	SHA3	ebx, ecx, edx, esi, eax, ebp+(49*04), 08f1bbcdch

	SHA3	eax, ebx, ecx, edx, esi, ebp+(50*04), 08f1bbcdch
	SHA3	esi, eax, ebx, ecx, edx, ebp+(51*04), 08f1bbcdch
	SHA3	edx, esi, eax, ebx, ecx, ebp+(52*04), 08f1bbcdch
	SHA3	ecx, edx, esi, eax, ebx, ebp+(53*04), 08f1bbcdch
	SHA3	ebx, ecx, edx, esi, eax, ebp+(54*04), 08f1bbcdch

	SHA3	eax, ebx, ecx, edx, esi, ebp+(55*04), 08f1bbcdch
	SHA3	esi, eax, ebx, ecx, edx, ebp+(56*04), 08f1bbcdch
	SHA3	edx, esi, eax, ebx, ecx, ebp+(57*04), 08f1bbcdch
	SHA3	ecx, edx, esi, eax, ebx, ebp+(58*04), 08f1bbcdch
	SHA3	ebx, ecx, edx, esi, eax, ebp+(59*04), 08f1bbcdch

	;=====================================================

	SHA4	eax, ebx, ecx, edx, esi, ebp+(60*04), 0ca62c1d6h
	SHA4	esi, eax, ebx, ecx, edx, ebp+(61*04), 0ca62c1d6h
	SHA4	edx, esi, eax, ebx, ecx, ebp+(62*04), 0ca62c1d6h
	SHA4	ecx, edx, esi, eax, ebx, ebp+(63*04), 0ca62c1d6h
	SHA4	ebx, ecx, edx, esi, eax, ebp+(64*04), 0ca62c1d6h

	SHA4	eax, ebx, ecx, edx, esi, ebp+(65*04), 0ca62c1d6h
	SHA4	esi, eax, ebx, ecx, edx, ebp+(66*04), 0ca62c1d6h
	SHA4	edx, esi, eax, ebx, ecx, ebp+(67*04), 0ca62c1d6h
	SHA4	ecx, edx, esi, eax, ebx, ebp+(68*04), 0ca62c1d6h
	SHA4	ebx, ecx, edx, esi, eax, ebp+(69*04), 0ca62c1d6h

	SHA4	eax, ebx, ecx, edx, esi, ebp+(70*04), 0ca62c1d6h
	SHA4	esi, eax, ebx, ecx, edx, ebp+(71*04), 0ca62c1d6h
	SHA4	edx, esi, eax, ebx, ecx, ebp+(72*04), 0ca62c1d6h
	SHA4	ecx, edx, esi, eax, ebx, ebp+(73*04), 0ca62c1d6h
	SHA4	ebx, ecx, edx, esi, eax, ebp+(74*04), 0ca62c1d6h

	SHA4	eax, ebx, ecx, edx, esi, ebp+(75*04), 0ca62c1d6h
	SHA4	esi, eax, ebx, ecx, edx, ebp+(76*04), 0ca62c1d6h
	SHA4	edx, esi, eax, ebx, ecx, ebp+(77*04), 0ca62c1d6h
	SHA4	ecx, edx, esi, eax, ebx, ebp+(78*04), 0ca62c1d6h
	SHA4	ebx, ecx, edx, esi, eax, ebp+(79*04), 0ca62c1d6h

	;=====================================================

	add	eax, 067452301h
	add	ebx, 0efcdab89h
	add	ecx, 098badcfeh
	add	edx, 010325476h
	add	esi, 0c3d2e1f0h
	
	mov	edi, [edi_]
	mov	ebp, [ebp_]

	retn	(01*04)